package io.burkard.cdk.services.events

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnEventBusProps {

  def apply(
    name: String,
    tags: Option[List[_ <: software.amazon.awscdk.services.events.CfnEventBus.TagEntryProperty]] = None,
    eventSourceName: Option[String] = None
  ): software.amazon.awscdk.services.events.CfnEventBusProps =
    (new software.amazon.awscdk.services.events.CfnEventBusProps.Builder)
      .name(name)
      .tags(tags.map(_.asJava).orNull)
      .eventSourceName(eventSourceName.orNull)
      .build()
}
