package io.burkard.cdk.services.events

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnEndpoint {

  def apply(
    internalResourceId: String,
    eventBuses: List[_],
    name: String,
    routingConfig: software.amazon.awscdk.services.events.CfnEndpoint.RoutingConfigProperty,
    description: Option[String] = None,
    roleArn: Option[String] = None,
    replicationConfig: Option[software.amazon.awscdk.services.events.CfnEndpoint.ReplicationConfigProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.events.CfnEndpoint =
    software.amazon.awscdk.services.events.CfnEndpoint.Builder
      .create(stackCtx, internalResourceId)
      .eventBuses(eventBuses.asJava)
      .name(name)
      .routingConfig(routingConfig)
      .description(description.orNull)
      .roleArn(roleArn.orNull)
      .replicationConfig(replicationConfig.orNull)
      .build()
}
