package io.burkard.cdk.services.emrserverless

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnApplicationProps {

  def apply(
    `type`: String,
    releaseLabel: String,
    name: Option[String] = None,
    networkConfiguration: Option[software.amazon.awscdk.services.emrserverless.CfnApplication.NetworkConfigurationProperty] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    autoStartConfiguration: Option[software.amazon.awscdk.services.emrserverless.CfnApplication.AutoStartConfigurationProperty] = None,
    initialCapacity: Option[List[_]] = None,
    maximumCapacity: Option[software.amazon.awscdk.services.emrserverless.CfnApplication.MaximumAllowedResourcesProperty] = None,
    autoStopConfiguration: Option[software.amazon.awscdk.services.emrserverless.CfnApplication.AutoStopConfigurationProperty] = None
  ): software.amazon.awscdk.services.emrserverless.CfnApplicationProps =
    (new software.amazon.awscdk.services.emrserverless.CfnApplicationProps.Builder)
      .`type`(`type`)
      .releaseLabel(releaseLabel)
      .name(name.orNull)
      .networkConfiguration(networkConfiguration.orNull)
      .tags(tags.map(_.asJava).orNull)
      .autoStartConfiguration(autoStartConfiguration.orNull)
      .initialCapacity(initialCapacity.map(_.asJava).orNull)
      .maximumCapacity(maximumCapacity.orNull)
      .autoStopConfiguration(autoStopConfiguration.orNull)
      .build()
}
