package io.burkard.cdk.services.connect

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPhoneNumber {

  def apply(
    internalResourceId: String,
    targetArn: String,
    countryCode: String,
    `type`: String,
    description: Option[String] = None,
    prefix: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.connect.CfnPhoneNumber =
    software.amazon.awscdk.services.connect.CfnPhoneNumber.Builder
      .create(stackCtx, internalResourceId)
      .targetArn(targetArn)
      .countryCode(countryCode)
      .`type`(`type`)
      .description(description.orNull)
      .prefix(prefix.orNull)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
