package io.burkard.cdk.services.cognito

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object UserPoolIdentityProviderOidcProps {

  def apply(
    clientId: String,
    issuerUrl: String,
    clientSecret: String,
    name: Option[String] = None,
    endpoints: Option[software.amazon.awscdk.services.cognito.OidcEndpoints] = None,
    attributeMapping: Option[software.amazon.awscdk.services.cognito.AttributeMapping] = None,
    scopes: Option[List[String]] = None,
    identifiers: Option[List[String]] = None,
    userPool: Option[software.amazon.awscdk.services.cognito.IUserPool] = None,
    attributeRequestMethod: Option[software.amazon.awscdk.services.cognito.OidcAttributeRequestMethod] = None
  ): software.amazon.awscdk.services.cognito.UserPoolIdentityProviderOidcProps =
    (new software.amazon.awscdk.services.cognito.UserPoolIdentityProviderOidcProps.Builder)
      .clientId(clientId)
      .issuerUrl(issuerUrl)
      .clientSecret(clientSecret)
      .name(name.orNull)
      .endpoints(endpoints.orNull)
      .attributeMapping(attributeMapping.orNull)
      .scopes(scopes.map(_.asJava).orNull)
      .identifiers(identifiers.map(_.asJava).orNull)
      .userPool(userPool.orNull)
      .attributeRequestMethod(attributeRequestMethod.orNull)
      .build()
}
