package io.burkard.cdk.services.cognito

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OidcEndpoints {

  def apply(
    userInfo: String,
    token: String,
    authorization: String,
    jwksUri: String
  ): software.amazon.awscdk.services.cognito.OidcEndpoints =
    (new software.amazon.awscdk.services.cognito.OidcEndpoints.Builder)
      .userInfo(userInfo)
      .token(token)
      .authorization(authorization)
      .jwksUri(jwksUri)
      .build()
}
