package io.burkard.cdk.services.cloudwatch

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object MetricExpressionConfig {

  def apply(
    usingMetrics: Map[String, _ <: software.amazon.awscdk.services.cloudwatch.IMetric],
    expression: String,
    period: Number,
    searchAccount: Option[String] = None,
    searchRegion: Option[String] = None
  ): software.amazon.awscdk.services.cloudwatch.MetricExpressionConfig =
    (new software.amazon.awscdk.services.cloudwatch.MetricExpressionConfig.Builder)
      .usingMetrics(usingMetrics.asJava)
      .expression(expression)
      .period(period)
      .searchAccount(searchAccount.orNull)
      .searchRegion(searchRegion.orNull)
      .build()
}
