package io.burkard.cdk.services.cloudfront.origins

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object RestApiOriginProps {

  def apply(
    keepaliveTimeout: Option[software.amazon.awscdk.Duration] = None,
    originShieldRegion: Option[String] = None,
    readTimeout: Option[software.amazon.awscdk.Duration] = None,
    connectionTimeout: Option[software.amazon.awscdk.Duration] = None,
    customHeaders: Option[Map[String, String]] = None,
    connectionAttempts: Option[Number] = None
  ): software.amazon.awscdk.services.cloudfront.origins.RestApiOriginProps =
    (new software.amazon.awscdk.services.cloudfront.origins.RestApiOriginProps.Builder)
      .keepaliveTimeout(keepaliveTimeout.orNull)
      .originShieldRegion(originShieldRegion.orNull)
      .readTimeout(readTimeout.orNull)
      .connectionTimeout(connectionTimeout.orNull)
      .customHeaders(customHeaders.map(_.asJava).orNull)
      .connectionAttempts(connectionAttempts.orNull)
      .build()
}
