package io.burkard.cdk.services.cloudfront.cfnStreamingDistribution

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object StreamingDistributionConfigProperty {

  def apply(
    enabled: Boolean,
    s3Origin: software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution.S3OriginProperty,
    comment: String,
    trustedSigners: software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution.TrustedSignersProperty,
    aliases: Option[List[String]] = None,
    priceClass: Option[String] = None,
    logging: Option[software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution.LoggingProperty] = None
  ): software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution.StreamingDistributionConfigProperty =
    (new software.amazon.awscdk.services.cloudfront.CfnStreamingDistribution.StreamingDistributionConfigProperty.Builder)
      .enabled(enabled)
      .s3Origin(s3Origin)
      .comment(comment)
      .trustedSigners(trustedSigners)
      .aliases(aliases.map(_.asJava).orNull)
      .priceClass(priceClass.orNull)
      .logging(logging.orNull)
      .build()
}
