package io.burkard.cdk.services.billingconductor

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPricingPlan {

  def apply(
    internalResourceId: String,
    name: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    description: Option[String] = None,
    pricingRuleArns: Option[List[String]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.billingconductor.CfnPricingPlan =
    software.amazon.awscdk.services.billingconductor.CfnPricingPlan.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .tags(tags.map(_.asJava).orNull)
      .description(description.orNull)
      .pricingRuleArns(pricingRuleArns.map(_.asJava).orNull)
      .build()
}
