package io.burkard.cdk.services.batch

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnComputeEnvironmentProps {

  def apply(
    `type`: String,
    state: Option[String] = None,
    serviceRole: Option[String] = None,
    computeEnvironmentName: Option[String] = None,
    tags: Option[Map[String, String]] = None,
    computeResources: Option[software.amazon.awscdk.services.batch.CfnComputeEnvironment.ComputeResourcesProperty] = None,
    unmanagedvCpus: Option[Number] = None,
    replaceComputeEnvironment: Option[Boolean] = None,
    updatePolicy: Option[software.amazon.awscdk.services.batch.CfnComputeEnvironment.UpdatePolicyProperty] = None
  ): software.amazon.awscdk.services.batch.CfnComputeEnvironmentProps =
    (new software.amazon.awscdk.services.batch.CfnComputeEnvironmentProps.Builder)
      .`type`(`type`)
      .state(state.orNull)
      .serviceRole(serviceRole.orNull)
      .computeEnvironmentName(computeEnvironmentName.orNull)
      .tags(tags.map(_.asJava).orNull)
      .computeResources(computeResources.orNull)
      .unmanagedvCpus(unmanagedvCpus.orNull)
      .replaceComputeEnvironment(replaceComputeEnvironment.map(Boolean.box).orNull)
      .updatePolicy(updatePolicy.orNull)
      .build()
}
