package io.burkard.cdk.services.backup

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BackupPlanProps {

  def apply(
    backupPlanName: Option[String] = None,
    backupPlanRules: Option[List[_ <: software.amazon.awscdk.services.backup.BackupPlanRule]] = None,
    backupVault: Option[software.amazon.awscdk.services.backup.IBackupVault] = None,
    windowsVss: Option[Boolean] = None
  ): software.amazon.awscdk.services.backup.BackupPlanProps =
    (new software.amazon.awscdk.services.backup.BackupPlanProps.Builder)
      .backupPlanName(backupPlanName.orNull)
      .backupPlanRules(backupPlanRules.map(_.asJava).orNull)
      .backupVault(backupVault.orNull)
      .windowsVss(windowsVss.map(Boolean.box).orNull)
      .build()
}
