package io.burkard.cdk.services.autoscaling

sealed abstract class OnDemandAllocationStrategy(val underlying: software.amazon.awscdk.services.autoscaling.OnDemandAllocationStrategy)
  extends Product
    with Serializable

object OnDemandAllocationStrategy {
  implicit def toAws(value: OnDemandAllocationStrategy): software.amazon.awscdk.services.autoscaling.OnDemandAllocationStrategy =
    Option(value).map(_.underlying).orNull

  case object Prioritized
    extends OnDemandAllocationStrategy(software.amazon.awscdk.services.autoscaling.OnDemandAllocationStrategy.PRIORITIZED)
}
