package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object InstancesDistribution {

  def apply(
    onDemandAllocationStrategy: Option[software.amazon.awscdk.services.autoscaling.OnDemandAllocationStrategy] = None,
    spotMaxPrice: Option[String] = None,
    spotAllocationStrategy: Option[software.amazon.awscdk.services.autoscaling.SpotAllocationStrategy] = None,
    onDemandBaseCapacity: Option[Number] = None,
    onDemandPercentageAboveBaseCapacity: Option[Number] = None,
    spotInstancePools: Option[Number] = None
  ): software.amazon.awscdk.services.autoscaling.InstancesDistribution =
    (new software.amazon.awscdk.services.autoscaling.InstancesDistribution.Builder)
      .onDemandAllocationStrategy(onDemandAllocationStrategy.orNull)
      .spotMaxPrice(spotMaxPrice.orNull)
      .spotAllocationStrategy(spotAllocationStrategy.orNull)
      .onDemandBaseCapacity(onDemandBaseCapacity.orNull)
      .onDemandPercentageAboveBaseCapacity(onDemandPercentageAboveBaseCapacity.orNull)
      .spotInstancePools(spotInstancePools.orNull)
      .build()
}
