package io.burkard.cdk.services.autoscaling

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EbsDeviceOptionsBase {

  def apply(
    iops: Option[Number] = None,
    deleteOnTermination: Option[Boolean] = None,
    volumeType: Option[software.amazon.awscdk.services.autoscaling.EbsDeviceVolumeType] = None
  ): software.amazon.awscdk.services.autoscaling.EbsDeviceOptionsBase =
    (new software.amazon.awscdk.services.autoscaling.EbsDeviceOptionsBase.Builder)
      .iops(iops.orNull)
      .deleteOnTermination(deleteOnTermination.map(Boolean.box).orNull)
      .volumeType(volumeType.orNull)
      .build()
}
