package io.burkard.cdk.services.apprunner

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnVpcConnector {

  def apply(
    internalResourceId: String,
    subnets: List[String],
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    vpcConnectorName: Option[String] = None,
    securityGroups: Option[List[String]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.apprunner.CfnVpcConnector =
    software.amazon.awscdk.services.apprunner.CfnVpcConnector.Builder
      .create(stackCtx, internalResourceId)
      .subnets(subnets.asJava)
      .tags(tags.map(_.asJava).orNull)
      .vpcConnectorName(vpcConnectorName.orNull)
      .securityGroups(securityGroups.map(_.asJava).orNull)
      .build()
}
