package io.burkard.cdk.cloudassembly.schema

sealed abstract class RequireApproval(val underlying: software.amazon.awscdk.cloudassembly.schema.RequireApproval)
  extends Product
    with Serializable

object RequireApproval {
  implicit def toAws(value: RequireApproval): software.amazon.awscdk.cloudassembly.schema.RequireApproval =
    Option(value).map(_.underlying).orNull

  case object Never
    extends RequireApproval(software.amazon.awscdk.cloudassembly.schema.RequireApproval.NEVER)

  case object Anychange
    extends RequireApproval(software.amazon.awscdk.cloudassembly.schema.RequireApproval.ANYCHANGE)

  case object Broadening
    extends RequireApproval(software.amazon.awscdk.cloudassembly.schema.RequireApproval.BROADENING)
}
