package io.burkard.cdk

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FingerprintOptions {

  def apply(
    ignoreMode: Option[software.amazon.awscdk.IgnoreMode] = None,
    exclude: Option[List[String]] = None,
    follow: Option[software.amazon.awscdk.SymlinkFollowMode] = None,
    extraHash: Option[String] = None
  ): software.amazon.awscdk.FingerprintOptions =
    (new software.amazon.awscdk.FingerprintOptions.Builder)
      .ignoreMode(ignoreMode.orNull)
      .exclude(exclude.map(_.asJava).orNull)
      .follow(follow.orNull)
      .extraHash(extraHash.orNull)
      .build()
}
