package io.burkard.cdk

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnOutput {

  def apply(
    internalResourceId: String,
    value: String,
    condition: Option[software.amazon.awscdk.CfnCondition] = None,
    description: Option[String] = None,
    exportName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.CfnOutput =
    software.amazon.awscdk.CfnOutput.Builder
      .create(stackCtx, internalResourceId)
      .value(value)
      .condition(condition.orNull)
      .description(description.orNull)
      .exportName(exportName.orNull)
      .build()
}
