package io.burkard.cdk.services.stepfunctions.tasks

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object TransformResources {

  def apply(
    instanceCount: Number,
    instanceType: software.amazon.awscdk.services.ec2.InstanceType,
    volumeEncryptionKey: Option[software.amazon.awscdk.services.kms.IKey] = None
  ): software.amazon.awscdk.services.stepfunctions.tasks.TransformResources =
    (new software.amazon.awscdk.services.stepfunctions.tasks.TransformResources.Builder)
      .instanceCount(instanceCount)
      .instanceType(instanceType)
      .volumeEncryptionKey(volumeEncryptionKey.orNull)
      .build()
}
