package io.burkard.cdk.services.ssm

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object StringParameterAttributes {

  def apply(
    `type`: Option[software.amazon.awscdk.services.ssm.ParameterType] = None,
    version: Option[Number] = None,
    simpleName: Option[Boolean] = None,
    parameterName: Option[String] = None
  ): software.amazon.awscdk.services.ssm.StringParameterAttributes =
    (new software.amazon.awscdk.services.ssm.StringParameterAttributes.Builder)
      .`type`(`type`.orNull)
      .version(version.orNull)
      .simpleName(simpleName.map(Boolean.box).orNull)
      .parameterName(parameterName.orNull)
      .build()
}
