package io.burkard.cdk.services.ses

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ReceiptFilter {

  def apply(
    internalResourceId: String,
    policy: Option[software.amazon.awscdk.services.ses.ReceiptFilterPolicy] = None,
    ip: Option[String] = None,
    receiptFilterName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ses.ReceiptFilter =
    software.amazon.awscdk.services.ses.ReceiptFilter.Builder
      .create(stackCtx, internalResourceId)
      .policy(policy.orNull)
      .ip(ip.orNull)
      .receiptFilterName(receiptFilterName.orNull)
      .build()
}
