package io.burkard.cdk.services.secretsmanager

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SecretAttributes {

  def apply(
    encryptionKey: Option[software.amazon.awscdk.services.kms.IKey] = None,
    secretPartialArn: Option[String] = None,
    secretCompleteArn: Option[String] = None
  ): software.amazon.awscdk.services.secretsmanager.SecretAttributes =
    (new software.amazon.awscdk.services.secretsmanager.SecretAttributes.Builder)
      .encryptionKey(encryptionKey.orNull)
      .secretPartialArn(secretPartialArn.orNull)
      .secretCompleteArn(secretCompleteArn.orNull)
      .build()
}
