package io.burkard.cdk.services.refactorspaces

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnApplication {

  def apply(
    internalResourceId: String,
    name: Option[String] = None,
    vpcId: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    apiGatewayProxy: Option[software.amazon.awscdk.services.refactorspaces.CfnApplication.ApiGatewayProxyInputProperty] = None,
    proxyType: Option[String] = None,
    environmentIdentifier: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.refactorspaces.CfnApplication =
    software.amazon.awscdk.services.refactorspaces.CfnApplication.Builder
      .create(stackCtx, internalResourceId)
      .name(name.orNull)
      .vpcId(vpcId.orNull)
      .tags(tags.map(_.asJava).orNull)
      .apiGatewayProxy(apiGatewayProxy.orNull)
      .proxyType(proxyType.orNull)
      .environmentIdentifier(environmentIdentifier.orNull)
      .build()
}
