package io.burkard.cdk.services.rds

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CredentialsBaseOptions {

  def apply(
    encryptionKey: Option[software.amazon.awscdk.services.kms.IKey] = None,
    secretName: Option[String] = None,
    excludeCharacters: Option[String] = None,
    replicaRegions: Option[List[_ <: software.amazon.awscdk.services.secretsmanager.ReplicaRegion]] = None
  ): software.amazon.awscdk.services.rds.CredentialsBaseOptions =
    (new software.amazon.awscdk.services.rds.CredentialsBaseOptions.Builder)
      .encryptionKey(encryptionKey.orNull)
      .secretName(secretName.orNull)
      .excludeCharacters(excludeCharacters.orNull)
      .replicaRegions(replicaRegions.map(_.asJava).orNull)
      .build()
}
