package io.burkard.cdk.services.personalize

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDatasetGroup {

  def apply(
    internalResourceId: String,
    name: String,
    domain: Option[String] = None,
    roleArn: Option[String] = None,
    kmsKeyArn: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.personalize.CfnDatasetGroup =
    software.amazon.awscdk.services.personalize.CfnDatasetGroup.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .domain(domain.orNull)
      .roleArn(roleArn.orNull)
      .kmsKeyArn(kmsKeyArn.orNull)
      .build()
}
