package io.burkard.cdk.services.personalize

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDataset {

  def apply(
    internalResourceId: String,
    name: String,
    schemaArn: String,
    datasetGroupArn: String,
    datasetType: String,
    datasetImportJob: Option[software.amazon.awscdk.services.personalize.CfnDataset.DatasetImportJobProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.personalize.CfnDataset =
    software.amazon.awscdk.services.personalize.CfnDataset.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .schemaArn(schemaArn)
      .datasetGroupArn(datasetGroupArn)
      .datasetType(datasetType)
      .datasetImportJob(datasetImportJob.orNull)
      .build()
}
