package io.burkard.cdk.services.opensearchservice

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object AdvancedSecurityOptions {

  def apply(
    masterUserPassword: Option[software.amazon.awscdk.SecretValue] = None,
    masterUserArn: Option[String] = None,
    masterUserName: Option[String] = None
  ): software.amazon.awscdk.services.opensearchservice.AdvancedSecurityOptions =
    (new software.amazon.awscdk.services.opensearchservice.AdvancedSecurityOptions.Builder)
      .masterUserPassword(masterUserPassword.orNull)
      .masterUserArn(masterUserArn.orNull)
      .masterUserName(masterUserName.orNull)
      .build()
}
