package io.burkard.cdk.services.networkfirewall

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnFirewallPolicyProps {

  def apply(
    firewallPolicyName: String,
    firewallPolicy: software.amazon.awscdk.services.networkfirewall.CfnFirewallPolicy.FirewallPolicyProperty,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    description: Option[String] = None
  ): software.amazon.awscdk.services.networkfirewall.CfnFirewallPolicyProps =
    (new software.amazon.awscdk.services.networkfirewall.CfnFirewallPolicyProps.Builder)
      .firewallPolicyName(firewallPolicyName)
      .firewallPolicy(firewallPolicy)
      .tags(tags.map(_.asJava).orNull)
      .description(description.orNull)
      .build()
}
