package io.burkard.cdk.services.mediaconnect

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnFlow {

  def apply(
    internalResourceId: String,
    name: String,
    source: software.amazon.awscdk.services.mediaconnect.CfnFlow.SourceProperty,
    availabilityZone: Option[String] = None,
    sourceFailoverConfig: Option[software.amazon.awscdk.services.mediaconnect.CfnFlow.FailoverConfigProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.mediaconnect.CfnFlow =
    software.amazon.awscdk.services.mediaconnect.CfnFlow.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .source(source)
      .availabilityZone(availabilityZone.orNull)
      .sourceFailoverConfig(sourceFailoverConfig.orNull)
      .build()
}
