package io.burkard.cdk.services.logs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSubscriptionFilterProps {

  def apply(
    logGroupName: String,
    filterPattern: String,
    destinationArn: String,
    roleArn: Option[String] = None
  ): software.amazon.awscdk.services.logs.CfnSubscriptionFilterProps =
    (new software.amazon.awscdk.services.logs.CfnSubscriptionFilterProps.Builder)
      .logGroupName(logGroupName)
      .filterPattern(filterPattern)
      .destinationArn(destinationArn)
      .roleArn(roleArn.orNull)
      .build()
}
