package io.burkard.cdk.services.kafkaconnect

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnConnectorProps {

  def apply(
    kafkaClusterEncryptionInTransit: software.amazon.awscdk.services.kafkaconnect.CfnConnector.KafkaClusterEncryptionInTransitProperty,
    plugins: List[_],
    connectorConfiguration: Map[String, String],
    kafkaCluster: software.amazon.awscdk.services.kafkaconnect.CfnConnector.KafkaClusterProperty,
    kafkaConnectVersion: String,
    connectorName: String,
    serviceExecutionRoleArn: String,
    kafkaClusterClientAuthentication: software.amazon.awscdk.services.kafkaconnect.CfnConnector.KafkaClusterClientAuthenticationProperty,
    capacity: software.amazon.awscdk.services.kafkaconnect.CfnConnector.CapacityProperty,
    workerConfiguration: Option[software.amazon.awscdk.services.kafkaconnect.CfnConnector.WorkerConfigurationProperty] = None,
    connectorDescription: Option[String] = None,
    logDelivery: Option[software.amazon.awscdk.services.kafkaconnect.CfnConnector.LogDeliveryProperty] = None
  ): software.amazon.awscdk.services.kafkaconnect.CfnConnectorProps =
    (new software.amazon.awscdk.services.kafkaconnect.CfnConnectorProps.Builder)
      .kafkaClusterEncryptionInTransit(kafkaClusterEncryptionInTransit)
      .plugins(plugins.asJava)
      .connectorConfiguration(connectorConfiguration.asJava)
      .kafkaCluster(kafkaCluster)
      .kafkaConnectVersion(kafkaConnectVersion)
      .connectorName(connectorName)
      .serviceExecutionRoleArn(serviceExecutionRoleArn)
      .kafkaClusterClientAuthentication(kafkaClusterClientAuthentication)
      .capacity(capacity)
      .workerConfiguration(workerConfiguration.orNull)
      .connectorDescription(connectorDescription.orNull)
      .logDelivery(logDelivery.orNull)
      .build()
}
