package io.burkard.cdk.services.iot.cfnTopicRule

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object DynamoDBActionProperty {

  def apply(
    hashKeyValue: String,
    hashKeyField: String,
    tableName: String,
    roleArn: String,
    rangeKeyType: Option[String] = None,
    hashKeyType: Option[String] = None,
    rangeKeyValue: Option[String] = None,
    payloadField: Option[String] = None,
    rangeKeyField: Option[String] = None
  ): software.amazon.awscdk.services.iot.CfnTopicRule.DynamoDBActionProperty =
    (new software.amazon.awscdk.services.iot.CfnTopicRule.DynamoDBActionProperty.Builder)
      .hashKeyValue(hashKeyValue)
      .hashKeyField(hashKeyField)
      .tableName(tableName)
      .roleArn(roleArn)
      .rangeKeyType(rangeKeyType.orNull)
      .hashKeyType(hashKeyType.orNull)
      .rangeKeyValue(rangeKeyValue.orNull)
      .payloadField(payloadField.orNull)
      .rangeKeyField(rangeKeyField.orNull)
      .build()
}
