package io.burkard.cdk.services.iam

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnGroup {

  def apply(
    internalResourceId: String,
    path: Option[String] = None,
    managedPolicyArns: Option[List[String]] = None,
    groupName: Option[String] = None,
    policies: Option[List[_]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.iam.CfnGroup =
    software.amazon.awscdk.services.iam.CfnGroup.Builder
      .create(stackCtx, internalResourceId)
      .path(path.orNull)
      .managedPolicyArns(managedPolicyArns.map(_.asJava).orNull)
      .groupName(groupName.orNull)
      .policies(policies.map(_.asJava).orNull)
      .build()
}
