package io.burkard.cdk.services.glue

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnClassifier {

  def apply(
    internalResourceId: String,
    csvClassifier: Option[software.amazon.awscdk.services.glue.CfnClassifier.CsvClassifierProperty] = None,
    grokClassifier: Option[software.amazon.awscdk.services.glue.CfnClassifier.GrokClassifierProperty] = None,
    jsonClassifier: Option[software.amazon.awscdk.services.glue.CfnClassifier.JsonClassifierProperty] = None,
    xmlClassifier: Option[software.amazon.awscdk.services.glue.CfnClassifier.XMLClassifierProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.glue.CfnClassifier =
    software.amazon.awscdk.services.glue.CfnClassifier.Builder
      .create(stackCtx, internalResourceId)
      .csvClassifier(csvClassifier.orNull)
      .grokClassifier(grokClassifier.orNull)
      .jsonClassifier(jsonClassifier.orNull)
      .xmlClassifier(xmlClassifier.orNull)
      .build()
}
