package io.burkard.cdk.services.fsx.cfnVolume

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OpenZFSConfigurationProperty {

  def apply(
    parentVolumeId: String,
    dataCompressionType: Option[String] = None,
    readOnly: Option[Boolean] = None,
    storageCapacityQuotaGiB: Option[Number] = None,
    storageCapacityReservationGiB: Option[Number] = None,
    options: Option[List[String]] = None,
    nfsExports: Option[List[_]] = None,
    copyTagsToSnapshots: Option[Boolean] = None,
    recordSizeKiB: Option[Number] = None,
    userAndGroupQuotas: Option[List[_]] = None,
    originSnapshot: Option[software.amazon.awscdk.services.fsx.CfnVolume.OriginSnapshotProperty] = None
  ): software.amazon.awscdk.services.fsx.CfnVolume.OpenZFSConfigurationProperty =
    (new software.amazon.awscdk.services.fsx.CfnVolume.OpenZFSConfigurationProperty.Builder)
      .parentVolumeId(parentVolumeId)
      .dataCompressionType(dataCompressionType.orNull)
      .readOnly(readOnly.map(Boolean.box).orNull)
      .storageCapacityQuotaGiB(storageCapacityQuotaGiB.orNull)
      .storageCapacityReservationGiB(storageCapacityReservationGiB.orNull)
      .options(options.map(_.asJava).orNull)
      .nfsExports(nfsExports.map(_.asJava).orNull)
      .copyTagsToSnapshots(copyTagsToSnapshots.map(Boolean.box).orNull)
      .recordSizeKiB(recordSizeKiB.orNull)
      .userAndGroupQuotas(userAndGroupQuotas.map(_.asJava).orNull)
      .originSnapshot(originSnapshot.orNull)
      .build()
}
