package io.burkard.cdk.services.forecast

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDatasetProps {

  def apply(
    domain: String,
    datasetName: String,
    schema: AnyRef,
    datasetType: String,
    tags: Option[List[_]] = None,
    dataFrequency: Option[String] = None,
    encryptionConfig: Option[AnyRef] = None
  ): software.amazon.awscdk.services.forecast.CfnDatasetProps =
    (new software.amazon.awscdk.services.forecast.CfnDatasetProps.Builder)
      .domain(domain)
      .datasetName(datasetName)
      .schema(schema)
      .datasetType(datasetType)
      .tags(tags.map(_.asJava).orNull)
      .dataFrequency(dataFrequency.orNull)
      .encryptionConfig(encryptionConfig.orNull)
      .build()
}
