package io.burkard.cdk.services.events.targets

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ApiDestination {

  def apply(
    apiDestination: software.amazon.awscdk.services.events.IApiDestination,
    maxEventAge: Option[software.amazon.awscdk.Duration] = None,
    eventRole: Option[software.amazon.awscdk.services.iam.IRole] = None,
    event: Option[software.amazon.awscdk.services.events.RuleTargetInput] = None,
    deadLetterQueue: Option[software.amazon.awscdk.services.sqs.IQueue] = None,
    pathParameterValues: Option[List[String]] = None,
    headerParameters: Option[Map[String, String]] = None,
    retryAttempts: Option[Number] = None,
    queryStringParameters: Option[Map[String, String]] = None
  ): software.amazon.awscdk.services.events.targets.ApiDestination =
    software.amazon.awscdk.services.events.targets.ApiDestination.Builder
      .create(apiDestination)
      .maxEventAge(maxEventAge.orNull)
      .eventRole(eventRole.orNull)
      .event(event.orNull)
      .deadLetterQueue(deadLetterQueue.orNull)
      .pathParameterValues(pathParameterValues.map(_.asJava).orNull)
      .headerParameters(headerParameters.map(_.asJava).orNull)
      .retryAttempts(retryAttempts.orNull)
      .queryStringParameters(queryStringParameters.map(_.asJava).orNull)
      .build()
}
