package io.burkard.cdk.services.events

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EventBusAttributes {

  def apply(
    eventBusName: String,
    eventBusArn: String,
    eventBusPolicy: String,
    eventSourceName: Option[String] = None
  ): software.amazon.awscdk.services.events.EventBusAttributes =
    (new software.amazon.awscdk.services.events.EventBusAttributes.Builder)
      .eventBusName(eventBusName)
      .eventBusArn(eventBusArn)
      .eventBusPolicy(eventBusPolicy)
      .eventSourceName(eventSourceName.orNull)
      .build()
}
