package io.burkard.cdk.services.events

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ApiDestination {

  def apply(
    internalResourceId: String,
    endpoint: String,
    connection: software.amazon.awscdk.services.events.IConnection,
    apiDestinationName: Option[String] = None,
    description: Option[String] = None,
    rateLimitPerSecond: Option[Number] = None,
    httpMethod: Option[software.amazon.awscdk.services.events.HttpMethod] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.events.ApiDestination =
    software.amazon.awscdk.services.events.ApiDestination.Builder
      .create(stackCtx, internalResourceId)
      .endpoint(endpoint)
      .connection(connection)
      .apiDestinationName(apiDestinationName.orNull)
      .description(description.orNull)
      .rateLimitPerSecond(rateLimitPerSecond.orNull)
      .httpMethod(httpMethod.orNull)
      .build()
}
