package io.burkard.cdk.services.emr.cfnCluster

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SpotProvisioningSpecificationProperty {

  def apply(
    timeoutAction: String,
    timeoutDurationMinutes: Number,
    blockDurationMinutes: Option[Number] = None,
    allocationStrategy: Option[String] = None
  ): software.amazon.awscdk.services.emr.CfnCluster.SpotProvisioningSpecificationProperty =
    (new software.amazon.awscdk.services.emr.CfnCluster.SpotProvisioningSpecificationProperty.Builder)
      .timeoutAction(timeoutAction)
      .timeoutDurationMinutes(timeoutDurationMinutes)
      .blockDurationMinutes(blockDurationMinutes.orNull)
      .allocationStrategy(allocationStrategy.orNull)
      .build()
}
