package io.burkard.cdk.services.elasticsearch

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CustomEndpointOptions {

  def apply(
    domainName: String,
    hostedZone: Option[software.amazon.awscdk.services.route53.IHostedZone] = None,
    certificate: Option[software.amazon.awscdk.services.certificatemanager.ICertificate] = None
  ): software.amazon.awscdk.services.elasticsearch.CustomEndpointOptions =
    (new software.amazon.awscdk.services.elasticsearch.CustomEndpointOptions.Builder)
      .domainName(domainName)
      .hostedZone(hostedZone.orNull)
      .certificate(certificate.orNull)
      .build()
}
