package io.burkard.cdk.services.elasticsearch

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CognitoOptions {

  def apply(
    role: software.amazon.awscdk.services.iam.IRole,
    userPoolId: String,
    identityPoolId: String
  ): software.amazon.awscdk.services.elasticsearch.CognitoOptions =
    (new software.amazon.awscdk.services.elasticsearch.CognitoOptions.Builder)
      .role(role)
      .userPoolId(userPoolId)
      .identityPoolId(identityPoolId)
      .build()
}
