package io.burkard.cdk.services.efs

sealed abstract class OutOfInfrequentAccessPolicy(val underlying: software.amazon.awscdk.services.efs.OutOfInfrequentAccessPolicy)
  extends Product
    with Serializable

object OutOfInfrequentAccessPolicy {
  implicit def toAws(value: OutOfInfrequentAccessPolicy): software.amazon.awscdk.services.efs.OutOfInfrequentAccessPolicy =
    Option(value).map(_.underlying).orNull

  case object After1Access
    extends OutOfInfrequentAccessPolicy(software.amazon.awscdk.services.efs.OutOfInfrequentAccessPolicy.AFTER_1_ACCESS)
}
