package io.burkard.cdk.services.ecs

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FluentdLogDriver {

  def apply(
    subSecondPrecision: Option[Boolean] = None,
    tag: Option[String] = None,
    labels: Option[List[String]] = None,
    maxRetries: Option[Number] = None,
    asyncConnect: Option[Boolean] = None,
    envRegex: Option[String] = None,
    address: Option[String] = None,
    retryWait: Option[software.amazon.awscdk.Duration] = None,
    env: Option[List[String]] = None,
    bufferLimit: Option[Number] = None
  ): software.amazon.awscdk.services.ecs.FluentdLogDriver =
    software.amazon.awscdk.services.ecs.FluentdLogDriver.Builder
      .create()
      .subSecondPrecision(subSecondPrecision.map(Boolean.box).orNull)
      .tag(tag.orNull)
      .labels(labels.map(_.asJava).orNull)
      .maxRetries(maxRetries.orNull)
      .asyncConnect(asyncConnect.map(Boolean.box).orNull)
      .envRegex(envRegex.orNull)
      .address(address.orNull)
      .retryWait(retryWait.orNull)
      .env(env.map(_.asJava).orNull)
      .bufferLimit(bufferLimit.orNull)
      .build()
}
