package io.burkard.cdk.services.ecs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ExternalTaskDefinitionAttributes {

  def apply(
    networkMode: Option[software.amazon.awscdk.services.ecs.NetworkMode] = None,
    taskRole: Option[software.amazon.awscdk.services.iam.IRole] = None,
    taskDefinitionArn: Option[String] = None
  ): software.amazon.awscdk.services.ecs.ExternalTaskDefinitionAttributes =
    (new software.amazon.awscdk.services.ecs.ExternalTaskDefinitionAttributes.Builder)
      .networkMode(networkMode.orNull)
      .taskRole(taskRole.orNull)
      .taskDefinitionArn(taskDefinitionArn.orNull)
      .build()
}
