package io.burkard.cdk.services.ecs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object BottleRocketImage {

  def apply(
    variant: Option[software.amazon.awscdk.services.ecs.BottlerocketEcsVariant] = None,
    architecture: Option[software.amazon.awscdk.services.ec2.InstanceArchitecture] = None,
    cachedInContext: Option[Boolean] = None
  ): software.amazon.awscdk.services.ecs.BottleRocketImage =
    software.amazon.awscdk.services.ecs.BottleRocketImage.Builder
      .create()
      .variant(variant.orNull)
      .architecture(architecture.orNull)
      .cachedInContext(cachedInContext.map(Boolean.box).orNull)
      .build()
}
