package io.burkard.cdk.services.ec2

sealed abstract class AmazonLinuxKernel(val underlying: software.amazon.awscdk.services.ec2.AmazonLinuxKernel)
  extends Product
    with Serializable

object AmazonLinuxKernel {
  implicit def toAws(value: AmazonLinuxKernel): software.amazon.awscdk.services.ec2.AmazonLinuxKernel =
    Option(value).map(_.underlying).orNull

  case object Kernel5X
    extends AmazonLinuxKernel(software.amazon.awscdk.services.ec2.AmazonLinuxKernel.KERNEL5_X)
}
