package io.burkard.cdk.services.databrew.cfnJob

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ProfileConfigurationProperty {

  def apply(
    columnStatisticsConfigurations: Option[List[_]] = None,
    datasetStatisticsConfiguration: Option[software.amazon.awscdk.services.databrew.CfnJob.StatisticsConfigurationProperty] = None,
    entityDetectorConfiguration: Option[software.amazon.awscdk.services.databrew.CfnJob.EntityDetectorConfigurationProperty] = None,
    profileColumns: Option[List[_]] = None
  ): software.amazon.awscdk.services.databrew.CfnJob.ProfileConfigurationProperty =
    (new software.amazon.awscdk.services.databrew.CfnJob.ProfileConfigurationProperty.Builder)
      .columnStatisticsConfigurations(columnStatisticsConfigurations.map(_.asJava).orNull)
      .datasetStatisticsConfiguration(datasetStatisticsConfiguration.orNull)
      .entityDetectorConfiguration(entityDetectorConfiguration.orNull)
      .profileColumns(profileColumns.map(_.asJava).orNull)
      .build()
}
