package io.burkard.cdk.services.customerprofiles.cfnIntegration

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FlowDefinitionProperty {

  def apply(
    triggerConfig: software.amazon.awscdk.services.customerprofiles.CfnIntegration.TriggerConfigProperty,
    kmsArn: String,
    flowName: String,
    tasks: List[_],
    sourceFlowConfig: software.amazon.awscdk.services.customerprofiles.CfnIntegration.SourceFlowConfigProperty,
    description: Option[String] = None
  ): software.amazon.awscdk.services.customerprofiles.CfnIntegration.FlowDefinitionProperty =
    (new software.amazon.awscdk.services.customerprofiles.CfnIntegration.FlowDefinitionProperty.Builder)
      .triggerConfig(triggerConfig)
      .kmsArn(kmsArn)
      .flowName(flowName)
      .tasks(tasks.asJava)
      .sourceFlowConfig(sourceFlowConfig)
      .description(description.orNull)
      .build()
}
